﻿using System;
using System.Linq;
using System.Activities;
using System.Activities.Statements;
using System.Collections.Generic;

namespace EvenOddWfHostAndClient
{
  class Program
  {
    static void Main(string[] args)
    {
        // Kod klienta służący do interakcji z użytkownikiem.
        Console.Write("Wpisz liczbę: ");
      string userInput = Console.ReadLine();

      // Sprawdzanie poprawności danych wejściowych i przetwarzanie łańcucha znaków 
      // na liczbę całkowitą (parametr result).
      int result;
      while (!int.TryParse(userInput, out result))
      {
          Console.Write("Wpisz prawidłową liczbę: ");
        userInput = Console.ReadLine();
      }

      // Wywoływanie procesu i wyświetlanie wyników.
      Console.WriteLine(EvenOddWfHost(result));

      // Wstrzymywanie programu do czasu zakończenia pracy przez użytkownika.
      Console.WriteLine("Wciśnij dowolny klawisz, aby zakończyć.");
      Console.ReadKey();
    }

    // Oddzielenie kodu hosta od kodu klienta.
    private static string EvenOddWfHost(int toCheck)
    {
        // Tworzenie kolekcji Dictionary na argument wyjściowy.
      IDictionary<string, object> output;

      // Wywołanie procesu, przekazanie argumentu i pobranie wyników (zmienna output).
      output = WorkflowInvoker.Invoke(
        new EvenOddWf() { NumberToCheck = toCheck });

      // Zwrócenie wyników.
      return output["OutputMsg"].ToString();
    }

  }
}
